/*
 * Decompiled with CFR 0.152.
 */
package surgegen;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import surgegen.GeneralDefinitions;
import surgegen.Quality;
import surgegen.SURGEGenMainForm;

public class QualitySelector
extends JDialog {
    Quality qualityToReturn;
    boolean isPositive = false;
    JList list;
    SURGEGenMainForm parent;
    private JButton addButton;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JList qualityList;

    public QualitySelector(Frame parent, boolean modal) {
        super(parent, modal);
        this.parent = (SURGEGenMainForm)parent;
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.isPositive = this.parent.isPositive;
        this.list = this.parent.getList(this.isPositive);
        this.qualityList.setModel(new DefaultListModel());
        this.qualityList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component renderer = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (renderer instanceof JLabel && value instanceof Quality) {
                    ((JLabel)renderer).setText(((Quality)value).getName());
                }
                return renderer;
            }
        });
        this.buildQualityList();
    }

    @Override
    public String getTitle() {
        return GeneralDefinitions.QUALITY_SELECTOR_TITLES[this.parent.languageConstant];
    }

    private void initComponents() {
        this.addButton = new JButton();
        this.cancelButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.qualityList = new JList();
        this.setDefaultCloseOperation(2);
        this.setTitle(this.getTitle());
        this.setResizable(false);
        this.addButton.setText("Add Quality");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualitySelector.this.addButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualitySelector.this.cancelButtonActionPerformed(evt);
            }
        });
        this.qualityList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.qualityList);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton, -1, 116, Short.MAX_VALUE).addGap(18, 18, 18).addComponent(this.cancelButton, -2, 117, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 244, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.qualityToReturn = (Quality)this.qualityList.getSelectedValue();
        if (this.parent.updateKarma(1, this.qualityToReturn.getKarma(), this.isPositive)) {
            ((DefaultListModel)this.parent.getList(this.isPositive).getModel()).addElement(this.qualityToReturn);
            this.setVisible(false);
            this.dispose();
        } else {
            JOptionPane.showMessageDialog(this, "Cannot add ");
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(QualitySelector.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(QualitySelector.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(QualitySelector.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(QualitySelector.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QualitySelector dialog = new QualitySelector((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private void buildQualityList() {
        DefaultListModel listModel = (DefaultListModel)this.qualityList.getModel();
        ArrayList<Quality> usedQualities = new ArrayList<Quality>();
        listModel.clear();
        for (Object object : ((DefaultListModel)this.parent.getList(this.isPositive).getModel()).toArray()) {
            usedQualities.add((Quality)object);
        }
        if (this.isPositive) {
            for (Quality quality : GeneralDefinitions.POSITIVE_QUALITY_ARRAY) {
                if (Collections.frequency(usedQualities, quality) >= quality.maxUses || quality.karma > this.parent.maxKarma - this.parent.currentPosKarma || !this.checkCompatable(quality, usedQualities)) continue;
                listModel.addElement(quality);
            }
        } else {
            for (Quality quality : GeneralDefinitions.NEGATIVE_QUALITY_ARRAY) {
                if (Collections.frequency(usedQualities, quality) >= quality.maxUses || quality.karma > this.parent.maxNegKarma - this.parent.currentNegKarma || !this.checkCompatable(quality, usedQualities)) continue;
                listModel.addElement(quality);
            }
        }
    }

    private boolean checkCompatable(Quality quality, ArrayList<Quality> usedQualities) {
        ArrayList<Quality> incompatables = new ArrayList<Quality>();
        for (Quality currentQuality : usedQualities) {
            incompatables.addAll(Arrays.asList(currentQuality.incompatable));
        }
        return !incompatables.contains(quality);
    }
}

