-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function onInit()
	local node = DB.createNode("options.TBOX", "string");
	if node then
		node.onUpdate = update;
	end
	node = DB.createNode("options.REVL", "string");
	if node then
		node.onUpdate = update;
	end

	update();
end

function update()
	if OptionsManager.isOption("TBOX", "on") then
		if User.isHost() and OptionsManager.isOption("REVL", "off") then
			setVisible(false);
		else
			setVisible(true);
		end
	else
		setVisible(false);
	end
end

function processDrop(draginfo)
	-- Make sure we add in the modifier stack, if any
	ModifierStack.applyToRoll(draginfo);

	-- Build a dice string by processing the die list
	local dicestr = ChatManager.convertDieListToString(draginfo.getDieList());
	if draginfo.getNumberData() ~= 0 then
		if draginfo.getNumberData() > 0 then
			dicestr = dicestr .. "+" .. draginfo.getNumberData();
		else
			dicestr = dicestr .. draginfo.getNumberData();
		end
	end

	-- Send the special message for TheBox drops
	local dragtype = draginfo.getType();
	local dragdesc = draginfo.getDescription();
	if dragtype == "fullattack" then
		dragtype = "attack";
		dragdesc = draginfo.getStringData();
	end
	ChatManager.sendSpecialMessage(ChatManager.SPECIAL_MSGTYPE_THEBOX, {dragtype, dragdesc, dicestr});
end

function onDrop(x, y, draginfo)
	if OptionsManager.isOption("TBOX", "on") then
		if draginfo.isType("fullattack") then
			ModifierStack.setLockCount(draginfo.getSlotCount());
			for i = 1, draginfo.getSlotCount() do
				draginfo.setSlot(i);
				processDrop(draginfo);
			end
		else
			processDrop(draginfo);
		end
	end

	-- Let FG know that this drop event is handled
	return true;
end
