-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

local bab = 0;
local bab_start = 0;
local bab_end = 0;

local grp = 0;
local grp_start = 0;
local grp_end = 0;

local hoverbab = nil;
local hovergrp = nil;
local clickbab = nil;
local clickgrp = nil;

local dragging = false;

function parseComponents()
	local starts, ends, babstr, grpstr = string.find(getValue(), "([%+%-]?%d+)/([%+%-]?%d+)");
	if starts then
		bab = tonumber(babstr) or 0;
		bab_start = starts;
		bab_end = starts + #babstr;
		
		grp = tonumber(grpstr) or 0;
		grp_start = bab_end + 1;
		grp_end = ends + 1;
	else
		bab = 0;
		bab_start = 0;
		bab_end = 0;
		
		grp = 0;
		grp_start = 0;
		grp_end = 0;
	end
end

function onHover(oncontrol)
	if hasFocus() or dragging then
		return;
	end

	-- Reset selection when the cursor leaves the control
	if not oncontrol then
		hoverbab = nil;
		hovergrp = nil;
		
		setCursorPosition(0);
	end
end

function onHoverUpdate(x, y)
	hoverx, hovery = x, y;

	if hasFocus() or dragging then
		return;
	end

	hoverbab = nil;
	hovergrp = nil;
		
	-- Hilight skill hovered on
	parseComponents();
	local index = getIndexAt(x, y);

	if (index >= bab_start and index < bab_end) then
		setCursorPosition(bab_start);
		setSelectionPosition(bab_end);
		
		hoverbab = true;
		
		setHoverCursor("hand");
		return true;
	end
	
	if (index >= grp_start and index < grp_end) then
		setCursorPosition(grp_start);
		setSelectionPosition(grp_end);
		
		hovergrp = true;
		
		setHoverCursor("hand");
		return true;
	end
	
	setHoverCursor("arrow");
	setCursorPosition(0);
end

function onDoubleClick(x, y)
	if hoverbab then
		ChatManager.DoubleClickNPC("attack", bab, "[ATTACK] Base attack", {npc = window.getDatabaseNode()});
		return true;
	end
	
	if hovergrp then
		ChatManager.DoubleClickNPC("dice", grp, "Grapple check", {npc = window.getDatabaseNode()});
		return true;
	end
end

function onDrag(button, x, y, draginfo)
	if dragging then
		return true;
	end

	if clickbab then
		draginfo.setType("attack");
		draginfo.setDescription("[ATTACK] Base attack");
		draginfo.setNumberData(bab);
		draginfo.setDieList({ "d20" });
		draginfo.setShortcutData("npc", window.getDatabaseNode().getNodeName());
		
		clickbab = nil;
		dragging = true;
		return true;
	end

	if clickgrp then
		draginfo.setType("dice");
		draginfo.setDescription("Grapple check");
		draginfo.setNumberData(grp);
		draginfo.setDieList({ "d20" });
		draginfo.setShortcutData("npc", window.getDatabaseNode().getNodeName());
		
		clickgrp = nil;
		dragging = true;
		return true;
	end

	return true;
end

function onDragEnd(dragdata)
	setCursorPosition(0);
	dragging = false;
end

function onClickDown(button, x, y)
	-- Suppress default processing to support dragging
	clickbab = hoverbab;
	clickgrp = hovergrp;

	return true;
end

function onClickRelease(button, x, y)
	setFocus();

	local n = getIndexAt(x, y);
	setSelectionPosition(n);
	setCursorPosition(n);

	return true;
end

