-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function clearSelection()
	for k, w in ipairs(getWindows()) do
		w.base.setFrame(nil);
	end
end

function addIdentity(id, label, localdatabasenode)
	for k, v in ipairs(activeidentities) do
		if v == id then
			return;
		end
	end

	win = NodeManager.createSafeWindow(self);
	if win then
		win.setId(id);
		win.label.setValue(label);

		win.setLocalNode(localdatabasenode);

		if id then
			win.portrait.setIcon("portrait_" .. id .. "_charlist");
		end
	end
end

function onInit()
	activeidentities = User.getAllActiveIdentities();

	getWindows()[1].close();
	createWindowWithClass("identityselection_newentry");

	localIdentities = User.getLocalIdentities();
	for n, v in ipairs(localIdentities) do
		local label_val = NodeManager.getSafeChildValue(v.databasenode, "name", "");
		addIdentity(v.id, label_val, v.databasenode);
	end

	User.getRemoteIdentities("charsheet", "name", addIdentity);
end
