-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function updateStatus()
	local percent_wounded = 0;
	local remaining_hp = window.hp.getValue() - window.wounds.getValue();
	if window.hp.getValue() > 0 then
		percent_wounded = window.wounds.getValue() / window.hp.getValue();
	end
	if percent_wounded <= 0 then
		window.wounds.setFont("ct_healthy_font");
		window.status.setFont("ct_healthy_font");
		window.status.setValue("Healthy");
	elseif percent_wounded <= .33 then
		window.wounds.setFont("ct_ltwound_font");
		window.status.setFont("ct_ltwound_font");
		window.status.setValue("Light");
	elseif percent_wounded <= .66 then
		window.wounds.setFont("ct_modwound_font");
		window.status.setFont("ct_modwound_font");
		window.status.setValue("Moderate");
	elseif percent_wounded <= 1 then
		window.wounds.setFont("ct_hvywound_font");
		window.status.setFont("ct_hvywound_font");
		if remaining_hp == 0 then
			window.status.setValue("Disabled");
		else
			window.status.setValue("Heavy");
		end
	else
		window.wounds.setFont("ct_dead_font");
		window.status.setFont("ct_dead_font");
		if remaining_hp > -10 then
			window.status.setValue("Dying");
		else
			window.status.setValue("Dead");
		end
	end
end
