-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

-- NOTE: onListRearranged and checkForEmpty override added to allow clients to 
-- drop effects onto the client combat tracker.  Since combat tracker node is
-- owned by the host, then client can not add nodes, but can edit an existing
-- node.  So, we are making sure that an empty node is always available on the host.
function onListRearranged(listchanged)
	checkForEmpty()
end

function checkForEmpty()
	for k, v in ipairs(getWindows()) do
		if v.label.getValue() == "" then
			return;
		end
	end

	NodeManager.createSafeWindow(self);
end

function getEffectListString()
	local s = "";
	for k, v in pairs(getWindows()) do
		if v.label.getValue() ~= "" then
			if s ~= "" then
				s = s .. ", ";
			end
			s = s .. v.label.getValue();
		end
	end
	return s;
end

function progressEffects(actor_old, actor_new)
	for k, v in ipairs(getWindows()) do
		if v.caster.getSource() == actor_new then
			local oldvalue = v.duration.getValue();
			local newvalue = oldvalue + v.adjustment.getValue()
			v.duration.setValue(newvalue);
			
			if newvalue == 0 and newvalue ~= oldvalue then
				expireEffect(v);
			end
		end

		-- Some effects are always addressed at beginning of actor's turn
		if actor_new == window then
			local effectlist = CombatCommon.parseEffect(v.label.getValue());

			for ek,ev in pairs(effectlist) do
				-- Check for ongoing damage effect
				if ev.type == "DMG" then
					applyEffectDamage(ev.val, ev.remainder);
				end

				-- Check for ongoing fast heal effect
				if ev.type == "FHEAL" then
					applyEffectFastHeal(ev.val);
				end

				-- Check for ongoing regeneration effect
				-- NOTE: Requires adding the idea of non-lethal damage tracking to CT
				--if ev.type == "REGEN" then
				--	applyEffectRegen(ev.val);
				--end
			end
		end
	end
end

function expireEffect(effectwin)
	-- Post a notification to the chat window
	local msg = {font = "systemfont", icon = "indicator_effect"};
	msg.text = "Effect '" .. effectwin.label.getValue() .. "' expired [on " .. window.name.getValue() .. "]";
	if window.type.getValue() == "pc" or window.show_npc.getState() then
		ChatManager.deliverMessage(msg);
	else
		msg.text = "[GM] " .. msg.text;
		ChatManager.addMessage(msg);
	end

	-- Delete the effect
	deleteChild(effectwin, true);
end

function applyEffectFastHeal(regen_val)
	-- Parameter validation
	if regen_val <= 0 then
		return;
	end

	-- Build damage notification message
	local msg = {font = "systemfont", icon = "indicator_effect"};
	msg.text = window.name.getValue() .. " fast heals " .. regen_val;
	
	-- Send the message to the correct recipients
	if window.type.getValue() == "pc" then
		ChatManager.deliverMessage(msg);
	else
		msg.text = "[GM] " .. msg.text;
		ChatManager.addMessage(msg);
	end

	-- Apply the damage
	CombatCommon.applyDamage("ct", window.getDatabaseNode(), 0 - regen_val);
end

function applyEffectDamage(dmg_val, dmg_type)
	-- Parameter validation
	if dmg_val <= 0 then
		return;
	end

	-- Build damage notification message
	local msg = {font = "systemfont", icon = "indicator_effect"};
	msg.text = window.name.getValue() .. " takes ongoing " .. dmg_val .. " damage";
	if dmg_type and dmg_type ~= "" then
		msg.text = msg.text .. " [" .. dmg_type .. "]";
	end
	
	-- Send the message to the correct recipients
	if window.type.getValue() == "pc" or window.show_npc.getState() then
		ChatManager.deliverMessage(msg);
	else
		msg.text = "[GM] " .. msg.text;
		ChatManager.addMessage(msg);
	end

	-- Apply the damage
	CombatCommon.applyDamage("ct", window.getDatabaseNode(), dmg_val);
end
