-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function onSortCompare(w1, w2)
	if w1.name.getValue() == "" then
		return true;
	elseif w2.name.getValue() == "" then
		return false;
	end

	return w1.name.getValue() > w2.name.getValue();
end

function onDrop(x, y, draginfo)
	if draginfo.isType("shortcut") then
		local link = draginfo.getShortcutData();
		if link == "referenceweapon" then
			local sourcenode = draginfo.getDatabaseNode();

			local type = sourcenode.getChild("type").getValue();
			if type == "Melee" or type == "Double" or type == "Both" then
				local newwin = NodeManager.createSafeWindow(self);
				if newwin then
					newwin.name.setValue(sourcenode.getChild("name").getValue());
					newwin.shortcut.setValue(draginfo.getShortcutData());

					local bab = getDatabaseNode().getParent().getChild("attackbonus").getChild("base").getValue();
					local numattacks = math.floor((bab - 1) / 5) + 1;
					if numattacks < 1 then
						numattacks = 1;
					end
					newwin.attacks.setValue(numattacks);

					local damagestring = sourcenode.getChild("damage").getValue();
					local dice, modifier = ChatManager.parseDieString(damagestring);
					newwin.damagedice.setDice(dice);

					local heft = sourcenode.getChild("heft").getValue();
					local dmgbonus = getDatabaseNode().getParent().getChild("abilities").getChild("strength").getChild("bonus").getValue();
					if heft == "Two-Handed" then
						dmgbonus = dmgbonus + math.floor(dmgbonus / 2);
					end
					dmgbonus = dmgbonus + modifier;
					newwin.damagebonus.setValue(dmgbonus);

					newwin.critrange.setValue(sourcenode.getChild("critrange").getValue());
					newwin.critmultiplier.setValue(sourcenode.getChild("crit").getValue());
				end
			end
			if type == "Ranged" or type == "Thrown" or type == "Both" then
				local newwin = NodeManager.createSafeWindow(self);
				if newwin then
					newwin.type.setState(true);
					newwin.name.setValue(sourcenode.getChild("name").getValue());
					newwin.shortcut.setValue(draginfo.getShortcutData());

					local bab = getDatabaseNode().getParent().getChild("attackbonus").getChild("base").getValue();
					local numattacks = math.floor((bab - 1) / 5) + 1;
					if numattacks < 1 then
						numattacks = 1;
					end
					newwin.attacks.setValue(numattacks);

					local damagestring = sourcenode.getChild("damage").getValue();
					local dice, modifier = ChatManager.parseDieString(damagestring);
					newwin.damagedice.setDice(dice);

					local dmgbonus = 0;
					if type == "Thrown" or type == "Both" then
						dmgbonus = dmgbonus + getDatabaseNode().getParent().getChild("abilities").getChild("strength").getChild("bonus").getValue();
					end
					dmgbonus = dmgbonus + modifier;
					newwin.damagebonus.setValue(dmgbonus);

					newwin.critrange.setValue(sourcenode.getChild("critrange").getValue());
					newwin.critmultiplier.setValue(sourcenode.getChild("crit").getValue());

					newwin.rangeincrement.setValue(sourcenode.getChild("range").getValue());
				end
			end

			return true;
		end
	end
end
