-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function getLevel()
	return tonumber(string.sub(getDatabaseNode().getChild("...").getName(), 6));
end

function getCast()
	return castnode.getValue();
end

function getPrepared()
	if isSpontaneous() then
		return nil;
	end

	return preparednode.getValue();
end

function preparedChanged()
	windowlist.updateCounters();
end

function castChanged()
	windowlist.updateCounters();
end

function isSpontaneous()
	return spontaneitynode.getValue() ~= 0;
end

function onInit()
	preparednode = NodeManager.createSafeChild(getDatabaseNode(), "prepared", "number");
	castnode = NodeManager.createSafeChild(getDatabaseNode(), "cast", "number");

	preparednode.onUpdate = preparedChanged;
	castnode.onUpdate = castChanged;

	spontaneitynode = NodeManager.createSafeChild(getDatabaseNode(), ".....spontaneous", "number");
	
	counter.updateSlots();
end

function updateVisibility()
	use_button.setVisible(counter.canCast());
end