-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function onDrop(x, y, draginfo)
	if minisheet then
		return false;
	end

	if draginfo.isType("spelllistentry") then
		local droptarget = getWindowAt(x, y);
		if droptarget then
			local dropsource = draginfo.getCustomData();

			if dropsource.windowlist ~= droptarget.spelllist then
				-- Create new entry based on entry in another level
				local newwin = NodeManager.createSafeWindow(droptarget.spelllist);
				if newwin then
					newwin.name.setValue(dropsource.name.getValue());
					newwin.shortdescription.setValue(dropsource.shortdescription.getValue());
					newwin.shortcut.setValue(dropsource.shortcut.getValue());

					newwin.counter.updateSlots();

					-- Close the source window
					dropsource.getDatabaseNode().delete();
				end
			end
		
			return true;
		end
	elseif draginfo.isType("spelldescwithlevel") then
		-- find the proper level window
		local targetlevel = draginfo.getNumberData();
		local droptarget = nil;
		for k, w in pairs(getWindows()) do
			local winlevel = tonumber(string.sub(w.getDatabaseNode().getName(), 6));
			if winlevel == targetlevel then
				droptarget = w;
				break;
			end
		end
		
		local availablenode = getDatabaseNode().getChild("..availablelevel" .. targetlevel);
		
		if droptarget then
			if availablenode and availablenode.getValue() ~= 0 then
				-- Create new entry based on shortcut with level
				local sourcenode = draginfo.getDatabaseNode();
				
				local newwin = NodeManager.createSafeWindow(droptarget.spelllist);
				if newwin then
					newwin.name.setValue(sourcenode.getChild("name").getValue());
					newwin.shortdescription.setValue(sourcenode.getChild("shortdescription").getValue());
					newwin.shortcut.setValue(draginfo.getShortcutData());

					newwin.counter.updateSlots();
				end
			end
			
			return true;
		end
	elseif draginfo.isType("shortcut") then
		if draginfo.getShortcutData() == "spelldesc" then
			-- Create new entry based on shortcut
			local droptarget = getWindowAt(x, y);
			if droptarget then
				local sourcenode = draginfo.getDatabaseNode();
				
				local newwin = NodeManager.createSafeWindow(droptarget.spelllist);
				if newwin then
					newwin.name.setValue(sourcenode.getChild("name").getValue());
					newwin.shortdescription.setValue(sourcenode.getChild("shortdescription").getValue());
					newwin.shortcut.setValue(draginfo.getShortcutData());

					newwin.counter.updateSlots();
				end
			
				return true;
			end
		end
	end
end

function onInit()
	NodeManager.createSafeChild(getDatabaseNode(), "level0");
	NodeManager.createSafeChild(getDatabaseNode(), "level1");
	NodeManager.createSafeChild(getDatabaseNode(), "level2");
	NodeManager.createSafeChild(getDatabaseNode(), "level3");
	NodeManager.createSafeChild(getDatabaseNode(), "level4");
	NodeManager.createSafeChild(getDatabaseNode(), "level5");
	NodeManager.createSafeChild(getDatabaseNode(), "level6");
	NodeManager.createSafeChild(getDatabaseNode(), "level7");
	NodeManager.createSafeChild(getDatabaseNode(), "level8");
	NodeManager.createSafeChild(getDatabaseNode(), "level9");
end

function onFilter(w)
	local levelname = w.getDatabaseNode().getName();
	local available_val = NodeManager.getSafeChildValue(getDatabaseNode(), "..available" .. levelname, 0);
	
	if available_val ~= 0 then
		return true;
	end
	
	return false;
end
