-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

slots = {};

function onInit()
	preparednode = NodeManager.createSafeChild(window.getDatabaseNode(), "prepared", "number");
	castnode = NodeManager.createSafeChild(window.getDatabaseNode(), "cast", "number");
	spontaneitynode = NodeManager.createSafeChild(window.getDatabaseNode(), ".....spontaneous", "number");
	availablenode = NodeManager.createSafeChild(window.getDatabaseNode(), ".....availablelevel" .. window.getLevel(), "number");
	castingmodenode = NodeManager.createSafeChild(window.getDatabaseNode(), ".......castingmode", "number");

	preparednode.onUpdate = updateSlots;
	castnode.onUpdate = updateSlots;
	spontaneitynode.onUpdate = updateSlots;
	availablenode.onUpdate = updateSlots;
	castingmodenode.onUpdate = updateSlots;
end

function onWheel(notches)
	if not OptionsManager.isMouseWheelEditEnabled() then
		return false;
	end

	adjustCounter(notches);
	return true;
end

function onClickDown(button, x, y)
	return true;
end

function onClickRelease(button, x, y)
	if isCastingMode() then
		local n = math.floor(x / spacing[1]) + 1;
		local current = castnode.getValue();
		
		if isSpontaneous() then
			local totalcast = getTotalCast();
			
			if n > totalcast then
				adjustCounter(1);
			elseif current > 0 then
				adjustCounter(-1);
			end
		else
			if n > current then
				adjustCounter(1);
			else
				adjustCounter(-1);
			end
		end
	else
		local n = math.floor(x / spacing[1]) + 1;
		local current = preparednode.getValue();
		
		if n > current then
			adjustCounter(1);
		else
			adjustCounter(-1);
		end
	end
	
	return true;
end

function isSpontaneous()
	return spontaneitynode.getValue() ~= 0;
end

function isCastingMode()
	if minisheet then
		return true;
	end

	return castingmodenode.getValue() ~= 0;
end

function getTotalCast()
	return window.windowlist.totalcast or 0;
end

function getMaxPrepared()
	local valuenode = NodeManager.createSafeChild(window.getDatabaseNode(), ".....availablelevel" .. window.getLevel(), "number");
	return valuenode.getValue();
end

function getMostPrepared()
	return window.windowlist.mostprepared or 0;
end

function updateSlots()
	-- Clear
	for k, v in ipairs(slots) do
		v.destroy();
	end
	
	slots = {};
	
	-- Construct based on values
	local p = preparednode.getValue();
	local c = castnode.getValue();

	local max = p;
	if isSpontaneous() or not isCastingMode() then
		max = getMaxPrepared();
	end
	
	local totalcast = getTotalCast();
	
	for i = 1, max do
		local widget = nil;

		if not isSpontaneous() then		
			if i > c then
				widget = addBitmapWidget(stateicons[1].off[1]);
			else
				widget = addBitmapWidget(stateicons[1].on[1]);
			end
			
			if i > p then
				widget.setColor("4fffffff");
			end
		else
			if i > totalcast then
				widget = addBitmapWidget(stateicons[1].off[1]);
			else
				widget = addBitmapWidget(stateicons[1].on[1]);
			end
			
			if i <= totalcast-c or not isCastingMode() then
				widget.setColor("4fffffff");
			end
		end
		
		local pos = spacing[1]*(i-0.5);
		widget.setPosition("left", pos, 0);
		
		slots[i] = widget;
	end

	local width = spacing[1]*max;
	
	if not minisheet and not isSpontaneous() and isCastingMode() then
		setAnchoredWidth(spacing[1]*getMostPrepared());
	else
		setAnchoredWidth(width);
	end
	
	-- Update a use_button if it exists
	if window.use_button then
		window.updateVisibility();
	end
end

function adjustCounter(val_adj)
	if isCastingMode() then
		local val = castnode.getValue();
		
		val = val + val_adj;

		if not isSpontaneous() then		
			local max = preparednode.getValue();

			if val > max then
				castnode.setValue(max);
			elseif val < 0 then
				castnode.setValue(0);
			else
				castnode.setValue(val);
			end
		else
			local max = getMaxPrepared();
			local totalcast = getTotalCast() + val_adj;
		
			if totalcast > max then
				if val - (totalcast - max) > 0 then
					castnode.setValue(val - (totalcast - max));
				else
					castnode.setValue(0);
				end
			elseif val < 0 then
				castnode.setValue(0);
			else
				castnode.setValue(val);
			end
		end
	else
		if isSpontaneous() then
			-- No nothing in preparation mode if spontaneous
			return true;
		end
	
		local max = getMaxPrepared();
		local val = preparednode.getValue();

		val = val + val_adj;
		
		if val > max then
			preparednode.setValue(max);
		elseif val < 0 then
			preparednode.setValue(0);
		else
			preparednode.setValue(val);
		end
	end
end

function canCast()
	if isSpontaneous() then
		local m = getMaxPrepared();
		local t = window.counter.getTotalCast();
		
		return (t < m);
	else
		local c = castnode.getValue();
		local p = preparednode.getValue();
		
		return (c < p);
	end
end
