-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function checkSource()
	source = window.getDatabaseNode().getChild("bonus");
	if source then
		enable(true);
	end
end
				
function setSourceValue(value)
	if source then
		source.setValue(value);
	end
end
				
function onInit()
	registerMenuItem("Delete number value", "delete", 4);

	--[[ Set up monitoring for the creation of the data node ]]
	window.getDatabaseNode().onChildAdded = checkSource;
	checkSource();
end

function update()
	setModifierDisplay(modifiernode.getValue());
end

function enable(state)
	if state then
		source = NodeManager.createSafeChild(window.getDatabaseNode(), "bonus", "number");
		if source then
			source.onDelete = onDelete;
			source.onUpdate = onUpdate;
			setValue(source.getValue());
		end
	else
		source.delete();
		source = nil;
		setValue(0);
	end

	setVisible(state);
end

function onUpdate()
	if source then
		setValue(source.getValue());
	end
end
			
function onValueChanged()
	if source then
		source.setValue(getValue());
	end
end
				
function onDelete()
	source = nil;
	setVisible(false);
end
				
function onMenuSelection(selection)
	if selection == 4 then
		enable(false);
	end
end

function onDrag(button, x, y, draginfo)
	if window.dice then
		window.dice.onDrag(button, x, y, draginfo);
	end
	return true;
end
