-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

iscustom = true;
sets = {};

function onInit()
	setnode = NodeManager.createSafeChild(getDatabaseNode(), "sets", "string");
	if setnode then
		setnode.onUpdate = setUpdated;
	end
	
	parseSets();
	
	setRadialDeleteOption();
	
	onCheckPenaltyChange();
	onStatNameUpdate();
end

function onClose()
	storeSets();
end

function onMenuSelection(item)
	if item == 6 then
		getDatabaseNode().delete();
	end
end

function onCheckPenaltyChange()
	if armorcheckmultiplier.getValue() ~= 0 then
		total.armorwidget.setVisible(true);
	else
		total.armorwidget.setVisible(false);
	end
end

function onStatNameUpdate()
	stat.onStatNameUpdate(statlabel.getSourceValue());
end

-- This function is called to set the entry to non-custom or custom.
-- Custom entries have configurable stats and editable labels.
function setCustom(state)
	iscustom = state;
	
	if not iscustom then
		label.setEnabled(false);
		label.setFrame(nil);
		
		statlabel.setStateFrame("hover", nil);
		statlabel.lockCycle(true);
	end
	
	setRadialDeleteOption();
end

-- Planned rank management
function resetPlanned()
	if getDatabaseNode().getChild("plannedranks") then
		getDatabaseNode().getChild("plannedranks").setValue(0);
	end
	if getDatabaseNode().getChild("plannedhalfranks") then
		getDatabaseNode().getChild("plannedhalfranks").setValue(0);
	end
end

function submitPlanned()
	local submitted = 0;

	if getDatabaseNode().getChild("ranks") and getDatabaseNode().getChild("plannedranks") then
		local planned = getDatabaseNode().getChild("plannedranks").getValue();
		getDatabaseNode().getChild("ranks").setValue(getDatabaseNode().getChild("ranks").getValue() + planned);
		submitted = submitted + planned;
	end
	if getDatabaseNode().getChild("halfranks") and getDatabaseNode().getChild("plannedhalfranks") then
		local planned = getDatabaseNode().getChild("plannedhalfranks").getValue();
		getDatabaseNode().getChild("halfranks").setValue(getDatabaseNode().getChild("halfranks").getValue() + planned);
		submitted = submitted + planned;
	end
	
	return submitted;
end

-- Functions to manage and store class skill set membership
function parseSets()
	sets = {};

	-- Set strings are number entries separated by commas and optional whitespace
	if setnode then
		for w in string.gmatch(setnode.getValue(), "(%d),?%s*") do
			if tonumber(w) then
				sets[tonumber(w)] = true;
			end
		end
	end
end

function storeSets()
	if setnode then
		local setstring = "";

		for k, v in pairs(sets) do
			setstring = setstring .. k .. ",";
		end

		setnode.setValue(setstring);
	end
end

function setInSet(set, state)
	if not state then
		sets[tonumber(set)] = nil;
	else
		sets[tonumber(set)] = true;
	end
	
	resetPlanned();
	storeSets();
end

function isInSet(set)
	return sets[tonumber(set)];
end

function setUpdated()
	parseSets();
	state.update();
end

function setRadialDeleteOption()
	resetMenuItems();

	if not iscustom then
		-- Disallow deletion of non-custom skills
		local labelval = label.getValue();
		
		if DataCommon.skilldata[labelval].sublabeling then
			-- Except for sublabeled skills that have several instances
			local count = 0;
			
			for k, w in pairs(windowlist.getWindows()) do
				if w.label.getValue() == labelval then
					count = count + 1;
				end
			end
			
			if count > 1 then
				registerMenuItem("Delete", "delete", 6);
			end
		end
	else
		registerMenuItem("Delete", "delete", 6);
	end
end
