-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function onInit()
	registerMenuItem("Direct adjustment", "unlock", 4);

	-- Initialize active set
	activesetnode = window.getDatabaseNode().getChild("activeskillset");
	if not activesetnode then
		activesetnode = NodeManager.createSafeChild(window.getDatabaseNode(), "activeskillset", "number");
		if activesetnode then
			activesetnode.setValue(1);
		end
	end
	if activesetnode then
		activesetnode.onUpdate = setChanged;
	end

	-- Construct default skills
	constructDefaultSkills();

	-- Update set states
	setChanged();
end

function onSortCompare(w1, w2)
	if w1.label.getValue() == "" then
		return true;
	elseif w2.label.getValue() == "" then
		return false;
	end

	return w1.label.getValue() > w2.label.getValue();
end

-- Create default skill selection
function constructDefaultSkills()
	-- Collect existing entries
	local entrymap = {};

	for k, w in pairs(getWindows()) do
		local label = w.label.getValue(); 
	
		if DataCommon.skilldata[label] then
			if not entrymap[label] then
				entrymap[label] = { w };
			else
				table.insert(entrymap[label], w);
			end
		end
	end

	-- Set properties and create missing entries for all known skills
	for k, t in pairs(DataCommon.skilldata) do
		local matches = entrymap[k];
		
		if not matches then
			local newwin = NodeManager.createSafeWindow(self);
			if newwin then
				newwin.label.setValue(k);
				matches = { newwin };
			end
		end
		
		-- Update properties
		for matchindex, match in pairs(matches) do
			if t.stat then
				match.statlabel.setSourceValue(t.stat);
			else
				match.statlabel.setSourceValue("");
				match.stat.setVisible(false);
				match.misc.setVisible(false);
				match.total.setVisible(false);
			end
			
			if t.sublabeling then
				match.sublabel.setVisible(true);
			end
			
			if t.armorcheckmultiplier then
				match.armorcheckmultiplier.setValue(t.armorcheckmultiplier);
			end
			
			match.setCustom(false);
		end
	end
end

function addNewInstance(label)
	local data = DataCommon.skilldata[label];
	
	if data and data.sublabeling then
		local newwin = NodeManager.createSafeWindow(self);
		if newwin then
			newwin.label.setValue(label);
			newwin.sublabel.setVisible(true);
			newwin.statlabel.setSourceValue(data.stat);
			newwin.setCustom(false);

			newwin.sublabel.setFocus();
		end
	end
end

function resetPlannedPoints()
	disablerecounts = true;

	for k,w in ipairs(getWindows()) do
		w.resetPlanned();
	end
	
	disablerecounts = false;
	skillPointsChanged();
end

function submitPlannedPoints()
	disablerecounts = true;

	-- Apply changes and count submitted ranks
	local total = 0;
	for k,w in ipairs(getWindows()) do
		total = total + w.submitPlanned();
		w.resetPlanned();
	end
	
	-- Adjust unspent count
	local unspentnode = window.getDatabaseNode().getChild("skillpoints.unspent");
	if unspentnode then
		if unspentnode.getValue() - total >= 0 then
			unspentnode.setValue(unspentnode.getValue() - total);
		else
			unspentnode.setValue(0);
		end
	end
	
	disablerecounts = false;
	skillPointsChanged();
end

function setChanged()
	resetPlannedPoints();

	for k, w in pairs(getWindows()) do
		w.state.update();
	end
end

function skillPointsChanged()
	if not disablerecounts and window.plannedskillpoints then
		window.plannedskillpoints.calculatePoints();
	end
end

function onMenuSelection()
	resetMenuItems();
	resetPlannedPoints();

	if not directadjustment then
		registerMenuItem("Planned increment", "lock", 4);
		directadjustment = true;
	else
		registerMenuItem("Direct adjustment", "unlock", 4);
		directadjustment = false;
	end
end
