-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function checkSource()
	source = window.getDatabaseNode().getChild("dice");
	if source then
		enable(true);
	end
end
				
function setSourceValue(value)
	local dietypetable = {};

	--[[ Allow both dragdata style and database style die lists ]]
	for k,v in ipairs(value) do
		if type(v) == "table" then
			table.insert(dietypetable, v.type);
		else
			table.insert(dietypetable, v);
		end
	end

	if source then
		source.setValue(dietypetable);
	end
end

function onInit()
	registerMenuItem("Delete dice", "delete", 3);
					
	--[[ Set up monitoring for the creation of the data node ]]
	window.getDatabaseNode().onChildAdded = checkSource;
	checkSource();
end

function enable(state)
	if state then
		source = NodeManager.createSafeChild(window.getDatabaseNode(), "dice", "dice");
		if source then
			source.onDelete = onDelete;
			source.onUpdate = onUpdate;
			setDice(source.getValue());
		end
	else
		source.delete();
		source = nil;
	end

	setVisible(state);
end

function onUpdate()
	if source then
		setDice(source.getValue());
	end
end
			
function onValueChanged()
	if source then
		source.setValue(getValue());
	end
end

function onDelete()
	source = nil;
	setVisible(false);
end
				
function onMenuSelection(selection)
	if selection == 3 then
		enable(false);
	end
end

function getDescriptionString()
	local desc = "Item [" .. window.name.getValue() .. "]";
	return desc;
end

function onDrag(button, x, y, draginfo)
	if source then
		draginfo.setType("dice");
		draginfo.setDescription(getDescriptionString());
		draginfo.setDieList(getDice());
		draginfo.setNumberData(window.bonus.getValue());
		draginfo.setShortcutData("charsheet", window.getDatabaseNode().getParent().getParent().getNodeName());
		return true;
	end
end

function onDoubleClick(x,y)
	if source then
		ChatManager.DoubleClickDieControl("dice", window.bonus.getValue(), getDescriptionString(), {pc = window.getDatabaseNode().getParent().getParent()}, getDice());
		return true;
	end
end			
