-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

widgets = {};
offsetx = 0;
offsety = 0;

function updateWidgets()
	for k, v in ipairs(widgets) do
		v.destroy();
	end

	local wt = window[icons[1].container[1]];
	local c = getValue();
	
	local w, h = getSize();
	
	for i = 1, c do
		local ox = offsetx * (-1 + ((i-1) % 2) * 2);
		local oy = offsety * (1 - math.floor((i-1) / 2) * 2);
	
		local widget = wt.addBitmapWidget(icons[1].icon[1]);
		widget.setPosition("center", ox, oy);
		
		widgets[i] = widget;
	end
end

function updateAttackFields()
	local c = getValue();
	
	if not isReadOnly() then
		window.attack1.setVisible(c >= 1);
		window.attack2.setVisible(c >= 2);
		window.attack3.setVisible(c >= 3);
		window.attack4.setVisible(c >= 4);
	end
end

function onValueChanged()
	if getValue() < 1 then
		setValue(1);
	elseif getValue() > 4 then
		setValue(4);
	end
	
	updateWidgets();
	updateAttackFields();
end

function getAttack(attack_num)
	-- Start with the attack name
	local node = window.getDatabaseNode();
	
	-- Start with the attack #
	local attack_text = "[ATTACK";
	if attack_num > 1 then
		attack_text = attack_text .. " #" .. attack_num;
	end
	attack_text = attack_text .. "] ";
	
	-- Add weapon name	
	attack_text = attack_text .. window[namefield[1]].getValue();
	
	-- Add in the critical tag
	local crit_text = node.getChild("critrange").getValue();
	local dash = string.find(crit_text, "-");
	if dash then
		crit_text = string.sub(crit_text, 1, dash-1);
	end
	local crit_threshold = tonumber(crit_text);
	if not crit_threshold then
		crit_threshold = 20;
	end
	if crit_threshold < 20 then
		attack_text = attack_text .. " [CRIT " .. crit_threshold .. "]";
	end
	
	-- Calculate the attack bonus
	local baseattack = node.getChild("bonus").getValue();
	if node.getChild("type").getValue() == 0 then
		baseattack = baseattack + node.getParent().getParent().getChild("attackbonus.melee.total").getValue();
	else
		baseattack = baseattack + node.getParent().getParent().getChild("attackbonus.ranged.total").getValue();
	end
	baseattack = baseattack + node.getChild("attack" .. attack_num .. "modifier").getValue() - ((attack_num-1)*5)

	-- Return the final name
	return attack_text, baseattack;
end

function onDrag(button, x, y, draginfo)
	draginfo.setType("fullattack");
	draginfo.setDescription("[FULL ATK] " .. window[namefield[1]].getValue());
	
	for i = 1, getValue() do
		local atk_name, atk_bonus = getAttack(i);
		draginfo.setSlot(i);

		draginfo.setDieList({ "d20" });
		draginfo.setStringData(atk_name);
		draginfo.setNumberData(atk_bonus);
		draginfo.setShortcutData("charsheet", window.getDatabaseNode().getParent().getParent().getNodeName());
	end

	return true;
end

function onInit()
	offsetx = tonumber(icons[1].offsetx[1]);
	offsety = tonumber(icons[1].offsety[1]);

	updateWidgets();
	updateAttackFields();
end

function onDoubleClick(x,y)
	if OptionsManager.isOption("DCLK", "on") then
		ModifierStack.setLockCount(getValue());
		
		for i = 1, getValue() do
			local atk_name, atk_bonus = getAttack(i);
			ChatManager.DoubleClickAction("attack", atk_bonus, atk_name, {pc = window.getDatabaseNode().getParent().getParent()});
		end
	end

	return true;
end			
