-- 
-- Please see the readme.txt file included with this distribution for 
-- attribution and copyright information.
--

function onSortCompare(w1, w2)
	if w1.value.getValue() == "" then
		return true;
	elseif w2.value.getValue() == "" then
		return false;
	end
				
	return w1.value.getValue() > w2.value.getValue();
end
					
function onClickDown(button, x, y)
	return true;
end
					
function onClickRelease(button, x, y)
	if not getNextWindow(nil) then
		local wnd = NodeManager.createSafeWindow(self);
		if wnd then
			wnd.value.setFocus();
		end
	end
	return true;
end
					
function onDrop(x, y, draginfo)
	if draginfo.isType("shortcut") then
		if draginfo.getShortcutData() == "referencefeat" then
			local sourcenode = draginfo.getDatabaseNode();

			local newwin = NodeManager.createSafeWindow(self);
			if newwin then
				newwin.value.setValue(sourcenode.getChild("name").getValue());
				newwin.shortcut.setValue(draginfo.getShortcutData());
			end

			return true;
		end
	end
end
